/* Programme de maintenance L'homme de ménage, version light.
Programmé par Maniack Crudelis.
http://www.crudelis.fr
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
Version 2.5. */
/*Copyright (c) 2008 Hervé Cottin. Ce fichier fait partie de l'Homme de ménage.

l'Homme de ménage est un logiciel libre; vous pouvez le redistribuer et/ou le modifier selon les termes de la GNU General Public License (Licence Publique Générale GNU) telle qu'elle a été publiée par la Free Software Foundation; soit la version 3 de la licence, soit (comme vous le souhaitez) toute version ultérieure.

l'Homme de ménage est distribué dans l'espoir qu'il sera utile, mais SANS LA MOINDRE GARANTIE; pas même la garantie implicite de COMMERCIABILITE ou d'ADEQUATION A UN BUT PARTICULIER.
Voir la GNU General Public License pour plus de détails.

Vous devriez avoir reçu une copie de la GNU General Public License en même temps que ce programme; sinon, merci d'écrire à la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston, MA02111-1307 USA.*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Utilitaire.h"
#include "Fichier.h"

struct parametres         /*Structure de données*/
{
    char HD[100];    /*Liste des disques durs*/
    int nb_disk;
};

int reperage_disque(char* disques); /*Repérages des disques durs (renvoi le nombre de disques trouvés*/
void Saisi_en_memoire ();   /*Vide les saisis gardées en mémoire*/
void Vidage_des_temp (struct parametres *param, int thumbs);    /*Vide les dossiers temporaires et les fichiers temporaires*/
void Defragmentation_des_disques (struct parametres *param);    /*Défrag les disques*/

int main (void)
{
    FILE* fichier_param;
    struct parametres param;
    char chaine[255];
    int saisi;
    int lsd;
    int temp;
    int defrag;
    int thumbs;
    int fin;
    system("title L'homme de ménage light");
    system("cls");
    puts("*******************************************************************************");
    printf("*                               %c%c%c%c%c    %c%c%c%c%c%c%c                              *\n",47,223,223,223,92,202,202,202,206,202,202,202);
    printf("*                              %c %c %c %c      %c                                 *\n",179,15,15,179,219);
    printf("*                              %c  %c  %c      %c                                 *\n",179,197,179,219);
    printf("*                              %c  %c  %c      %c                                 *\n",179,61,179,219);
    printf("*                               %c%c%c%c%c       %c                                 *\n",92,95,95,95,47,219);
    puts("*******************************************************************************");
    putsacc("Bonjour, je suis l'homme de ménage. Je viens entretenir ton PC.\n\n");
    param.nb_disk = reperage_disque(param.HD);
    fichier_param = ouvre_fichier("Paramètres.ini","r");
    fgets(chaine,255,fichier_param);
    fgets(chaine,255,fichier_param);
    Efface_char(chaine,":");
    saisi = atoi(chaine); /*Prend le paramètre saisi*/
    fgets(chaine,255,fichier_param);
    Efface_char(chaine,":");
    lsd = atoi(chaine);   /*Prend le paramètre lsd*/
    fgets(chaine,255,fichier_param);
    Efface_char(chaine,":");
    temp = atoi(chaine);  /*Prend le paramètre temp*/
    fgets(chaine,255,fichier_param);
    Efface_char(chaine,":");
    thumbs = atoi(chaine);  /*Prend le paramètre thumbs*/
    fgets(chaine,255,fichier_param);
    Efface_char(chaine,":");
    defrag = atoi(chaine);    /*Prend le paramètre defrag*/
    fclose(fichier_param);
    if (saisi)
        Saisi_en_memoire();
    if (lsd)
        system("\"lsd st\"");
    if (temp)
        Vidage_des_temp(&param,thumbs);
    if (defrag)
        Defragmentation_des_disques(&param);
    return 0;
}

void Saisi_en_memoire ()
{
    system("color 27");
    putsacc("Suppression des saisis gardées en mémoire.\n");
    system("reg delete \"HKCU\\Software\\Microsoft\\Internet Explorer\\TypedURLs\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\MediaPlayer\\Player\\RecentFileList\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\MediaPlayer\\Player\\RecentURLList\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\Search Assistant\\ACMru\\5603\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\Search Assistant\\ACMru\\5001\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\Search Assistant\\ACMru\\5604\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\RecentDocs\" /f");
    system("reg add \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\RecentDocs\"");
    system("reg delete \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\ComDlg32\\LastVisitedMRU\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\ComDlg32\\OpenSaveMRU\" /f");
    system("reg add \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\ComDlg32\\OpenSaveMRU\"");
    system("reg delete \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\RunMRU\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Paint\\Recent File List\" /va /f");
    system("reg delete \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Wordpad\\Recent File List\" /va /f");
}

void Vidage_des_temp (struct parametres *param, int thumbs)
{
    char cmdsys[100];
    int i;
    system("color 20");
    putsacc("Suppression des fichiers temporaires.\n");
    system("del /F /S /Q \"%systemroot%\\prefetch\\\"");
    system("del /F /S /Q \"%userprofile%\\Local Settings\\Temp\\\"");
    system("del /F /S /Q \"%userprofile%\\Local Settings\\Temporary Internet Files\\\"");
    system("del /F /S /Q \"%userprofile%\\Local Settings\\Temporary Internet Files\\Content.IE5\\\"");
    system("del /F /S /Q \"%userprofile%\\Recent\"");
    system("del /F /S /Q \"%systemroot%\\Temp\"");
    strcpy(cmdsys,"del /F /S /Q \"#:\\*.tmp\"");
    for(i=0;i<param->nb_disk;i++)
    {   /*Efface les fichiers tmp sur chaque disque*/
        cmdsys[14] = param->HD[i];
        system(cmdsys);
    }
    if (thumbs == 1)
    {
        strcpy(cmdsys,"del /f /s /q /as \"#:\\thumbs.db\"");
        for(i=0;i<param->nb_disk;i++)
        {   /*Efface les fichiers thumbs sur chaque disque*/
            cmdsys[18] = param->HD[i];
            system(cmdsys);
        }
    }
}

void Defragmentation_des_disques (struct parametres *param)
{
    char cmdsys[100];
    int i;
    system("color 2E");
    putsacc("Défragmentation des disques dur.\n");
    strcpy(cmdsys,"defrag #: -f");
    for(i=0;i<param->nb_disk;i++)
    {   /*Défragmente tous les disques*/
        cmdsys[7] = param->HD[i];
        system(cmdsys);
    }
}

int reperage_disque(char* disques)
{
    FILE* temp;
    FILE* temp2;
    char chaine[255];
    char chaine2[255];
    char lecteur[10];
    int i, j, nb_disque=0, lect;
    system("color 21");
    putsacc("# Repérage des disques dur et disques amovibles.\n");
    system("fsutil fsinfo drives > temp.tmp"); /*Identifie les lecteurs*/
    temp = ouvre_fichier("temp.tmp","r");
    temp2 = ouvre_fichier("temp2.tmp","w");
    fgets(chaine,255,temp);
    for(i=0;i<255;i++)
    {
        lect = getc(temp);
        if (lect == 0)  /*Convertit le caractère NULL en sourire!!!*/
            lect = 1;
        fprintf(temp2,"%c", lect);
    }
    fclose(temp);
    fclose(temp2);
    temp = ouvre_fichier("temp2.tmp","r");
    fgets(chaine,255,temp);
    Efface_char(chaine,":");
    do
    {
        j=0;
        do
        {
            for(i=0;i<strlen(chaine);i++)
                chaine[i] = chaine[i+1];
            lecteur[j++] = chaine[0];   /*Lit le caractère*/
        }while(chaine[0] != '\\');  /*Tant que l'on n'a pas le nom complet du disque*/
        lecteur[j] = '\0';  /*Termine la chaine*/
        for(i=0;i<strlen(chaine);i++)   /*Saute le caractère entre les disques*/
            chaine[i] = chaine[i+1];
        sprintf(chaine2,"fsutil fsinfo drivetype %s > temp.tmp", lecteur);
        system(chaine2);
        temp2 = ouvre_fichier("temp.tmp","r");
        fgets(chaine2,255,temp2);
        fclose(temp2);
        if (strstr(chaine2,"Lecteur fixe") != NULL || strstr(chaine2,"Lecteur amovible") != NULL)
        {
            //Si c'est un disque dur fixe ou amovible, vérifie son système de fichier
            sprintf(chaine2,"fsutil fsinfo volumeinfo %s > temp.tmp", lecteur);
            system(chaine2); /*Sort les info du disque*/
            temp2 = ouvre_fichier("temp.tmp","r");
            for(i=0;i<4;i++)
                fgets(chaine2,255,temp2);
            fclose(temp2);
            if(strstr(chaine2,": NTFS") || strstr(chaine2,": FAT"))
            {
                disques[nb_disque++] = lecteur[0];  //Note si c'est un disque dur ou un disque amovible en NTFS ou FAT
            }
        }
    }while(isalpha(chaine[1])); /*Si il y à un autre disque*/
    fclose(temp);
    return nb_disque;
}
